#!/usr/bin/env perl

use strict;
use warnings;

use lib '.';

use DeathByCaptcha::HttpClient;
use DeathByCaptcha::SocketClient;


my ($username, $password, $filename) = @ARGV;

# Put your DeathByCaptcha username & password here:
#my $client = DeathByCaptcha::HttpClient->new($username, $password);
my $client = DeathByCaptcha::SocketClient->new($username, $password);

printf("Your balance is %f US cents\n", $client->getBalance());

# Put your CAPTCHA image file name and desired solving timeout (in seconds) here:
my $captcha = $client->decode($filename, +DeathByCaptcha::Client::DEFAULT_TIMEOUT);
if (defined $captcha) {
    print "CAPTCHA " . $captcha->{"captcha"} . " solved: " . $captcha->{"text"} . "\n";

    # Report if the CAPTCHA was solved incorrectly.
    # Make sure it was in fact solved incorrect, do not just report every
    # CAPTCHA, or you'll get banned as abuser.
    #$client->report($captcha->{"captcha"});
}
