/*
 * Decompiled with CFR 0.152.
 */
package com.DeathByCaptcha;

import com.DeathByCaptcha.Captcha;
import com.DeathByCaptcha.Exception;
import com.DeathByCaptcha.User;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Client {
    public static final String API_VERSION = "DBC/Java v4.3.0";
    public static final int SOFTWARE_VENDOR_ID = 0;
    public static final int DEFAULT_TIMEOUT = 60;
    public static final int POLLS_INTERVAL = 5;
    public boolean isVerbose = false;
    protected String _username = "";
    protected String _password = "";

    protected void log(String string, String string2) {
        if (this.isVerbose) {
            System.out.println(System.currentTimeMillis() / 1000L + " " + string + (null != string2 ? ": " + string2 : ""));
        }
    }

    protected void log(String string) {
        this.log(string, null);
    }

    protected JSONObject getCredentials() {
        try {
            return new JSONObject().put("username", (Object)this._username).put("password", (Object)this._password);
        }
        catch (JSONException jSONException) {
            return new JSONObject();
        }
    }

    protected byte[] load(InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        byte[] byArray = new byte[]{};
        while (true) {
            try {
                n = inputStream.available();
            }
            catch (IOException iOException) {
                n = 0;
            }
            if (0 >= n) break;
            if (n2 + n > byArray.length) {
                byArray = Arrays.copyOf(byArray, byArray.length + n);
            }
            n2 += inputStream.read(byArray, n2, n);
        }
        return byArray;
    }

    protected byte[] load(File file) throws IOException, FileNotFoundException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byte[] byArray = this.load(fileInputStream);
            return byArray;
        }
    }

    public byte[] load(String string) throws IOException, FileNotFoundException {
        return this.load(new File(string));
    }

    public abstract void close();

    public abstract boolean connect() throws IOException;

    public Client(String string, String string2) {
        this._username = string;
        this._password = string2;
    }

    public abstract User getUser() throws IOException, Exception;

    public double getBalance() throws IOException, Exception {
        return this.getUser().balance;
    }

    public abstract Captcha upload(byte[] var1, String var2, int var3, byte[] var4, String var5, String var6) throws IOException, Exception;

    public abstract Captcha upload(byte[] var1, String var2, int var3, byte[] var4, String var5) throws IOException, Exception;

    public abstract Captcha upload(byte[] var1, int var2, byte[] var3, String var4) throws IOException, Exception;

    public abstract Captcha upload(byte[] var1) throws IOException, Exception;

    public Captcha upload(InputStream inputStream) throws IOException, Exception {
        return this.upload(this.load(inputStream));
    }

    public Captcha upload(File file) throws IOException, FileNotFoundException, Exception {
        return this.upload(this.load(file));
    }

    public Captcha upload(String string) throws IOException, FileNotFoundException, Exception {
        return this.upload(this.load(string));
    }

    public abstract Captcha getCaptcha(int var1) throws IOException, Exception;

    public Captcha getCaptcha(Captcha captcha) throws IOException, Exception {
        return this.getCaptcha(captcha.id);
    }

    public String getText(int n) throws IOException, Exception {
        return this.getCaptcha((int)n).text;
    }

    public String getText(Captcha captcha) throws IOException, Exception {
        return this.getText(captcha.id);
    }

    public abstract boolean report(int var1) throws IOException, Exception;

    public boolean report(Captcha captcha) throws IOException, Exception {
        return this.report(captcha.id);
    }

    public Captcha decode(byte[] byArray, String string, int n, byte[] byArray2, String string2, String string3, int n2) throws IOException, Exception, InterruptedException {
        long l = System.currentTimeMillis() + (long)((0 < n2 ? n2 : 60) * 1000);
        Captcha captcha = this.upload(byArray, string, n, byArray2, string2, string3);
        if (null != captcha) {
            while (l > System.currentTimeMillis() && !captcha.isSolved()) {
                Thread.sleep(5000L);
                captcha = this.getCaptcha(captcha.id);
            }
            if (captcha.isSolved() && captcha.isCorrect()) {
                return captcha;
            }
        }
        return null;
    }

    public Captcha decode(byte[] byArray, String string, int n, byte[] byArray2, String string2, int n2) throws IOException, Exception, InterruptedException {
        return this.decode(byArray, string, n, byArray2, string2, "", 0);
    }

    public Captcha decode(byte[] byArray, int n, byte[] byArray2, String string) throws IOException, Exception, InterruptedException {
        return this.decode(byArray, "", n, byArray2, string, 0);
    }

    public Captcha decode(byte[] byArray, int n) throws IOException, Exception, InterruptedException {
        return this.decode(byArray, "", n, null, "", 0);
    }

    public Captcha decode(byte[] byArray, String string) throws IOException, Exception, InterruptedException {
        return this.decode(byArray, string, 0, null, "", 0);
    }

    public Captcha decode(byte[] byArray, int n, int n2) throws IOException, Exception, InterruptedException {
        return this.decode(byArray, "", n, null, "", n2);
    }

    public Captcha decode(byte[] byArray, String string, int n) throws IOException, Exception, InterruptedException {
        return this.decode(byArray, string, 0, null, "", n);
    }

    public Captcha decode(byte[] byArray) throws IOException, Exception, InterruptedException {
        return this.decode(byArray, "", 0, null, "", 0);
    }

    public Captcha decode(InputStream inputStream, String string, int n, InputStream inputStream2, String string2, String string3, int n2) throws IOException, Exception, InterruptedException {
        return this.decode(this.load(inputStream), string, n, this.load(inputStream2), string2, string3, n2);
    }

    public Captcha decode(InputStream inputStream, String string, int n, InputStream inputStream2, String string2, int n2) throws IOException, Exception, InterruptedException {
        return this.decode(this.load(inputStream), string, n, this.load(inputStream2), string2, "", n2);
    }

    public Captcha decode(InputStream inputStream, int n, InputStream inputStream2, String string, String string2) throws IOException, Exception, InterruptedException {
        return this.decode(inputStream, "", n, inputStream2, string, string2, 0);
    }

    public Captcha decode(InputStream inputStream, int n, InputStream inputStream2, String string) throws IOException, Exception, InterruptedException {
        return this.decode(inputStream, "", n, inputStream2, string, "", 0);
    }

    public Captcha decode(InputStream inputStream, int n, int n2) throws IOException, Exception, InterruptedException {
        return this.decode(this.load(inputStream), "", n, null, "", n2);
    }

    public Captcha decode(InputStream inputStream, String string) throws IOException, Exception, InterruptedException {
        return this.decode(this.load(inputStream), string, 0, null, "", 0);
    }

    public Captcha decode(InputStream inputStream, String string, int n) throws IOException, Exception, InterruptedException {
        return this.decode(this.load(inputStream), string, 0, null, "", n);
    }

    public Captcha decode(InputStream inputStream, int n) throws IOException, Exception, InterruptedException {
        return this.decode(this.load(inputStream), n);
    }

    public Captcha decode(InputStream inputStream) throws IOException, Exception, InterruptedException {
        return this.decode(inputStream, 0);
    }

    public Captcha decode(File file, String string, int n, File file2, String string2, int n2) throws IOException, Exception, InterruptedException {
        return this.decode(this.load(file), string, n, this.load(file2), string2, n2);
    }

    public Captcha decode(File file, int n, File file2, String string) throws IOException, Exception, InterruptedException {
        return this.decode(file, "", n, file2, string, 0);
    }

    public Captcha decode(File file, int n, int n2) throws IOException, Exception, InterruptedException {
        return this.decode(this.load(file), "", n, null, "", n2);
    }

    public Captcha decode(File file, String string) throws IOException, Exception, InterruptedException {
        return this.decode(this.load(file), string, 0, null, "", 0);
    }

    public Captcha decode(File file, String string, int n) throws IOException, Exception, InterruptedException {
        return this.decode(this.load(file), string, 0, null, "", n);
    }

    public Captcha decode(File file, int n) throws IOException, FileNotFoundException, Exception, InterruptedException {
        return this.decode(this.load(file), n);
    }

    public Captcha decode(File file) throws IOException, FileNotFoundException, Exception, InterruptedException {
        return this.decode(file, 0);
    }

    public Captcha decode(String string, String string2, int n, String string3, String string4, int n2) throws IOException, Exception, InterruptedException {
        return this.decode(this.load(string), string2, n, this.load(string3), string4, n2);
    }

    public Captcha decode(String string, int n, String string2, String string3) throws IOException, Exception, InterruptedException {
        return this.decode(string, "", n, string2, string3, 0);
    }

    public Captcha decode(String string, int n, String string2, String string3, int n2) throws IOException, Exception, InterruptedException {
        return this.decode(string, "", n, string2, string3, n2);
    }

    public Captcha decode(String string, int n, int n2) throws IOException, Exception, InterruptedException {
        return this.decode(this.load(string), "", n, null, "", n2);
    }

    public Captcha decode(String string, String string2) throws IOException, Exception, InterruptedException {
        return this.decode(this.load(string), string2, 0, null, "", 0);
    }

    public Captcha decode(String string, String string2, int n) throws IOException, Exception, InterruptedException {
        return this.decode(this.load(string), string2, 0, null, "", n);
    }

    public Captcha decode(String string, int n) throws IOException, FileNotFoundException, Exception, InterruptedException {
        return this.decode(this.load(string), n);
    }

    public Captcha decode(String string) throws IOException, FileNotFoundException, Exception, InterruptedException {
        return this.decode(string, 0);
    }
}

