Const $DEATHBYCAPTCHA_VERSION = "DBC/AutoIt v4.5"
Const $DEATHBYCAPTCHA_HOST = "api.dbcapi.me"
Const $DEATHBYCAPTCHA_PORTS[2] = [8123, 8130]
Const $DEATHBYCAPTCHA_BASE64_TABLE = StringToASCIIArray("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=")
Const $DEATHBYCAPTCHA_POLL_INTERVALS[9] = [1, 1, 2, 3, 2, 2, 3, 2, 2]  ; in seconds
Const $DEATHBYCAPTCHA_DFLT_INTERVAL = 3  ; in seconds
Const $DEATHBYCAPTCHA_TCP_TIMEOUT = 3000  ; in miliseconds

Opt("TCPTimeout", $DEATHBYCAPTCHA_TCP_TIMEOUT)

Func _DeathByCaptchaBase64Encode($buf)
    Local $c = 0, $i = 1, $j = 0, $l = BinaryLen($buf), $m = Mod($l, 3)
    Local $dest = ""
    While $i <= $l - $m
        $c = BitOR(BitShift(BinaryMid($buf, $i, 1), -16), BitShift(BinaryMid($buf, $i + 1, 1), -8), BinaryMid($buf, $i + 2, 1))
        $dest &= Chr($DEATHBYCAPTCHA_BASE64_TABLE[BitShift(BitAND($c, 16515072), 18)])
        $dest &= Chr($DEATHBYCAPTCHA_BASE64_TABLE[BitShift(BitAND($c, 258048), 12)])
        $dest &= Chr($DEATHBYCAPTCHA_BASE64_TABLE[BitShift(BitAND($c, 4032), 6)])
        $dest &= Chr($DEATHBYCAPTCHA_BASE64_TABLE[BitAND($c, 63)])
        $i += 3
        $j += 4
    WEnd
    If 1 = $m Then
        $dest &= Chr($DEATHBYCAPTCHA_BASE64_TABLE[BitShift(BitAND(BinaryMid($buf, $i, 1), 252), 2)])
        $dest &= Chr($DEATHBYCAPTCHA_BASE64_TABLE[BitShift(BitAND(BinaryMid($buf, $i, 1), 3), -4)])
        $dest &= Chr($DEATHBYCAPTCHA_BASE64_TABLE[64])
        $dest &= Chr($DEATHBYCAPTCHA_BASE64_TABLE[64])
    ElseIf 2 = $m Then
        $c = BitOR(BitShift(BinaryMid($buf, $i, 1), -8), BinaryMid($buf, $i + 1, 1))
        $dest &= Chr($DEATHBYCAPTCHA_BASE64_TABLE[BitShift(BitAND($c, 64512), 10)])
        $dest &= Chr($DEATHBYCAPTCHA_BASE64_TABLE[BitShift(BitAND($c, 1008), 4)])
        $dest &= Chr($DEATHBYCAPTCHA_BASE64_TABLE[BitShift(BitAND($c, 15), -2)])
        $dest &= Chr($DEATHBYCAPTCHA_BASE64_TABLE[64])
    EndIf
    Return $dest
EndFunc

Func _DeathByCaptchaCall($buf)
    $buf &= Chr(13)
    $buf &= Chr(10)
    Local $response = ""
    TCPStartUp()
    Local $sock = TCPConnect(TCPNameToIp($DEATHBYCAPTCHA_HOST), Random($DEATHBYCAPTCHA_PORTS[0], $DEATHBYCAPTCHA_PORTS[1], 1))

    If @error Then
        MsgBox(0, "ERROR", "Could not connect, Error code: " & @error)
    EndIf

    If 0 < $sock Then
        Local $n = 0
        While 0 < StringLen($buf)
            $n = TCPSend($sock, $buf)
            If 0 < $n Then
                $buf = StringTrimLeft($buf, $n)
            EndIf
        WEnd
        Do
            $response &= TCPRecv($sock, 1024)
        Until @error OR 0 == StringCompare(Chr(10), StringRight($response, 1))
        TCPCloseSocket($sock)
    EndIf
    TCPShutdown()
    Return $response
EndFunc


; Uploads a CAPTCHA.
; Call with your DeathByCaptcha username/password and CAPTCHA file name.
; Returns unique CAPTCHA ID on success, 0 otherwise.
Func DeathByCaptchaUpload($username, $password, $captchaFileName)
    Local $f = FileOpen($captchaFileName, 16)
    If -1 < $f Then
        Local $img = FileRead($f)
        If @error Then
            $img = Binary("")
        EndIf
        FileClose($f)
        If 0 < BinaryLen($img) Then
            Local $a = StringRegExp(_DeathByCaptchaCall('{"version":"' & $DEATHBYCAPTCHA_VERSION & '","cmd":"upload","username":"' & $username & '","password":"' & $password & '","captcha":"' & _DeathByCaptchaBase64Encode($img) & '"}'), '"captcha"\s?:\s?(\d+)', 1)
            If 0 < UBound($a) Then
                Return Int($a[0])
            EndIf
        EndIf
    EndIf
    Return 0
EndFunc

; Fetches a CAPTCHA text.
; Call with unique CAPTCHA ID.
; Returns "" if the CAPTCHA is not solved or does not exist.
Func DeathByCaptchaGetText($captchaId)
    Local $a = StringRegExp(_DeathByCaptchaCall(StringFormat('{"version":"%s","cmd":"captcha","captcha":%d}', $DEATHBYCAPTCHA_VERSION, $captchaId)), '"text"\s?:\s?"([^"]+)"', 1)
    If 0 < UBound($a) Then
        Return $a[0]
    Else
        Return ""
    EndIf
EndFunc

; Remove an unsolved CAPTCHA you won't to be solved anymore.
; Call with your DeathByCaptcha username/password and unique CAPTCHA ID.
; Returns 1 on success, 0 otherwise.
Func DeathByCaptchaRemove($username, $password, $captchaId)
    Return StringRegExp(_DeathByCaptchaCall(StringFormat('{"version":"%s","cmd":"remove","username":"%s","password":"%s","captcha":%d}', $DEATHBYCAPTCHA_VERSION, $username, $password, $captchaId)), '"captcha"\s?:\s?0')
EndFunc

; Reports a CAPTCHA as incorrectly solved.
; Call with your DeathByCaptcha username/password and unique CAPTCHA ID.
; Returns 1 on success, 0 otherwise.
Func DeathByCaptchaReport($username, $password, $captchaId)
    Return StringRegExp(_DeathByCaptchaCall(StringFormat('{"version":"%s","cmd":"report","username":"%s","password":"%s","captcha":%d}', $DEATHBYCAPTCHA_VERSION, $username, $password, $captchaId)), '"is_correct"\s?:\s?false')
EndFunc

; Decodes a CAPTCHA by uploading it and polling for its status repeatedly.
; Call with your DeathByCaptcha username/password, CAPTCHA file name and
; solving timeout (in seconds).  Returns an two-elements array with CAPTCHA
; unique ID (zero if not solved) and text (empty string if not solved).
; Removes unsolved CAPTCHAs automatically.
Func DeathByCaptchaDecode($username, $password, $captchaFileName, $timeout)
    Local $result[2] = [0, ""]
    $result[0] = DeathByCaptchaUpload($username, $password, $captchaFileName)
    If 0 < $result[0] Then
        Local $deadline = $timeout * 1000
        Local $intvl_idx = 0
        Local $intvl = 0

        While 0 = StringLen($result[1]) AND 0 < $deadline
            $intvl = _DeathByCaptchaGetPollInterval($intvl_idx) * 1000
            $intvl_idx = $intvl_idx + 1

            Sleep($intvl)
            $deadline -= $intvl
            $result[1] = DeathByCaptchaGetText($result[0])
        WEnd
        If 0 = StringLen($result[1]) Then
            $result[0] = 0
        EndIf
    EndIf
    Return $result
EndFunc

Func _DeathByCaptchaGetPollInterval($idx)
    Local $intvl = 0

    If UBound($DEATHBYCAPTCHA_POLL_INTERVALS) > $idx Then
      $intvl = $DEATHBYCAPTCHA_POLL_INTERVALS[$idx]
    Else
      $intvl = $DEATHBYCAPTCHA_DFLT_INTERVAL
    EndIf

    Return $intvl
EndFunc

; Usage example
; =============
;
; Call DeathByCaptchaDecode() function with your DBC username, password,
; CAPTCHA file name, and desired solving timeout (in seconds) as arguments.
; You'll receive an array of two elements: numeric CAPTCHA ID and its text;
; CAPTCHA ID will be greater than zero if the CAPTCHA was solved.
;
;$result = DeathByCaptchaDecode($CmdLine[1], $CmdLine[2], $CmdLine[3], 60)
;MsgBox(0, "decode()", StringFormat('ID: %s, text: %s', $result[0], $result[1]))
